@echo off
setlocal

:: Check for admin rights
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo This script requires administrator privileges.
    pause
    exit /b
)

echo Adding entries to hosts file...

set HOSTS_FILE=%SystemRoot%\System32\drivers\etc\hosts

:: Backup current hosts file
copy "%HOSTS_FILE%" "%HOSTS_FILE%.bak" >nul

:: Add entries (avoiding duplicates)
findstr /C:"164.138.19.170 www.ptnmed.ir ptnmed.ir" "%HOSTS_FILE%" >nul || echo 164.138.19.170 www.ptnmed.ir ptnmed.ir>>"%HOSTS_FILE%"
findstr /C:"164.138.22.35 www.ptnmed.com ptnmed.com" "%HOSTS_FILE%" >nul || echo 164.138.22.35 www.ptnmed.com ptnmed.com>>"%HOSTS_FILE%"
findstr /C:"164.138.19.171 www.ptnshop.ir ptnshop.ir" "%HOSTS_FILE%" >nul || echo 164.138.19.171 www.ptnshop.ir ptnshop.ir>>"%HOSTS_FILE%"

:: Flush DNS cache
echo Flushing DNS cache...
ipconfig /flushdns

echo Done.
pause
